{*
* JPresta Doctor, JPresta Doctor PRO and Speed pack are powered by Jpresta (jpresta . com)
*
*    @author    Jpresta
*    @copyright Jpresta
*    @license   See the license of this module in file LICENSE.txt, thank you.
*}
<script>
    const lbl_delete_ctrl = "{l s='Delete this control' mod=$module_name}";
    const lbl_run_diagnostic = "{l s='Run diagnostic for this control' mod=$module_name}";
    const lbl_fixable = "{l s='Fixable' mod=$module_name}";
    const lbl_not_fixable = "{l s='Not fixable' mod=$module_name}";
    const lbl_fixed = "{l s='Fixed' mod=$module_name}";
    const lbl_fix_error = "{l s='Fix error' mod=$module_name}";
    const lbl_fix_pb = "{l s='Fix this problem' mod=$module_name}";
    const lbl_delete_pb = "{l s='Delete this problem' mod=$module_name}";
    const lbl_running_control = "{l s='Running control' mod=$module_name}";
    const lbl_repairing_problem = "{l s='Repairing problem' mod=$module_name}";
    const lbl_problem_found_sing = "{l s='%d problem found in %d ms' mod=$module_name}";
    const lbl_problem_found = "{l s='%d problems found in %d ms' mod=$module_name}";
    const lbl_repair_start = "{l s='Starting repair...' mod=$module_name}";
    const lbl_repair_no_problem = "{l s='No problem to repair' mod=$module_name}";
    const lbl_report_empty = "{l s='Report is empty' mod=$module_name}";
    const lbl_repair_complete = "{l s='Repair complete' mod=$module_name}";
    const lbl_repair_stopped = "{l s='Repair stopped' mod=$module_name}";
    const lbl_other_running = "{l s='Cannot start while another task is running' mod=$module_name}";
    const lbl_diag_start = "{l s='Starting diagnostic...' mod=$module_name}";
    const lbl_diag_complete = "{l s='Diagnostic complete' mod=$module_name}";
    const lbl_diag_stopped = "{l s='Diagnostic stopped' mod=$module_name}";
    const lbl_diag_no_control = "{l s='No control to run' mod=$module_name}";
    const lbl_confirm_reset = "{l s='All controls will be reset to the original list. Are you sure?' mod=$module_name}";
    const lbl_confirm_reset_ok = "{l s='All controls have been reset' mod=$module_name}";

    $(document).ready(function () {
        // Display initial stats
        displayStats();

        // Display last report info
        if ({$problem_count|intval}) {
            setTimeout(function () {
                logInReport("\n👉 {l s='The last diagnostic found %d problems on your shop' sprintf=[$problem_count] mod=$module_name}")
            }, 1000);
        }
        else {
            setTimeout(function () {
                {if $needs_settings_review}
                logInReport("\n👉 {l s='Before starting the diagnostic, please review the settings marked with an eye' mod=$module_name}&nbsp;<div class=need_review style=\"vertical-align: middle; display: inline-block;\"></div>")
                {else}
                logInReport("\n👉 {l s='Now you should start a diagnostic. Enjoy!' mod=$module_name}")
                {/if}
            }, 2000);
        }
    });
    function getLocalizationSettings() {
        return {
            processing: "{l s='Loading data...' mod=$module_name}",
            search: "{l s='Search' mod=$module_name}:",
            lengthMenu: "{l s='Showing _MENU_ rows' mod=$module_name}",
            info: "{l s='Showing _START_ to _END_ of _TOTAL_ rows' mod=$module_name}",
            zeroRecords: "{l s='No data to display' mod=$module_name}",
            emptyTable: "{l s='No data to display' mod=$module_name}",
            paginate: {
                first: "{l s='First' mod=$module_name}",
                previous: "{l s='Previous' mod=$module_name}",
                next: "{l s='Next' mod=$module_name}",
                last: "{l s='Last' mod=$module_name}"
            }
        }
    }
</script>
<div class="row">
    <!-- Doctor illustration -->
    <div class="col-md-2">
        <div class="doctor-logo">
            <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/doctor-waiting.png" id="doc-waiting" class="doc-face" width="160" height="200" alt="Doctor waiting">
            <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/doctor-happy.png"   id="doc-happy"   class="doc-face" width="160" height="200" alt="Doctor happy">
            <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/doctor-sad.png"     id="doc-sad"     class="doc-face" width="160" height="200" alt="Doctor sad">
            <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/doctor-crying.png"  id="doc-crying"  class="doc-face" width="160" height="200" alt="Doctor crying">
            <div id="doctor-logo-text"><span id="pbCount"></span></div>
        </div>
    </div>

    <!-- Report panel -->
    <div class="col-md-8">
        <div id="reportPanel" style="margin-bottom: 1rem">
            <pre id="report">ℹ️ {l s='Here’s your diagnostic report. You can launch a full scan or select a specific control to run.' mod=$module_name}
</pre>

            <button id="clearLogs" class="btn btn-xs" onclick="$('#report').html('');return false">
                <i class="material-icons" style="vertical-align: middle">clear</i>
                {l s='Clear logs' mod=$module_name}
            </button>
        </div>
    </div>

    <!-- Meca illustration -->
    <div class="col-md-2">
        <div class="meca-logo">
            <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/meca-waiting.png" id="meca-waiting" class="meca-face" width="160" height="200" alt="Meca waiting">
            <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/meca-happy.png"   id="meca-happy"   class="meca-face" width="160" height="200" alt="Meca happy">
            <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/meca-showing.png" id="meca-showing" class="meca-face" width="160" height="200" alt="Meca showing">
            <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/meca-sad.png" id="meca-sad" class="meca-face" width="205" height="200" alt="Meca sad">
        </div>
    </div>

</div>

<div class="row">
    <!-- Start/Stop diagnostic buttons -->
    <div class="col-md-2" style="text-align: center">
        <div class="actions">
            <button id="startDiagnostic" class="btn btn-success">
                <i class="icon-play"></i>&nbsp;{l s='Start diagnostic' mod=$module_name}
            </button>
            <button id="stopDiagnostic" class="btn btn-danger">
                <i class="icon-stop"></i>&nbsp;{l s='Stop diagnostic' mod=$module_name}
            </button>
            <button id="stoppingDiagnostic" class="btn btn-danger" disabled>
                <i class="icon-stop"></i>&nbsp;{l s='Stopping diagnostic...' mod=$module_name}
            </button>
        </div>
        <button class="btn btn-sm btn-link" onclick="$('#doctor-controls-content').toggle();return false;"><i class="icon-cogs"></i>&nbsp;{l s='Show/hide settings' mod=$module_name}</button>
    </div>

    <!-- Progress bar -->
    <div class="col-md-8">
        <div id="diagnostic-progress">
            <div class="progress" style="height:36px;margin-bottom:0">
                <div class="progress-bar progress-bar-striped progress-bar-animated"
                     role="progressbar" style="width:0%; text-align:left; white-space: nowrap; color: #333; padding-left:10px; line-height:36px; font-size:inherit">
                </div>
            </div>
        </div>
    </div>

    <!-- Start/Stop repairing buttons -->
    <div class="col-md-2" style="text-align: center">
        <div class="actions">
            <button id="openRepairInfo" class="btn btn-sm btn-link">
                <i class="icon-info-sign"></i>
            </button>
            <button id="startRepair" class="btn btn-success">
                <i class="icon-wrench"></i>&nbsp;{l s='Repair my shop!' mod=$module_name}
            </button>
            <button id="stopRepair" class="btn btn-danger">
                <i class="icon-stop"></i>&nbsp;{l s='Stop repairing' mod=$module_name}
            </button>
            <button id="stoppingRepair" class="btn btn-danger" disabled>
                <i class="icon-stop"></i>&nbsp;{l s='Stopping repairs...' mod=$module_name}
            </button>
        </div>
    </div>

</div>

<div id="doctor-controls" style="margin-top: 1rem;">
{if $needs_settings_review}
    <div class="alert alert-warning" role="alert">
        {l s='Before starting the diagnostic, please review the settings marked with an eye' mod=$module_name}&nbsp;<div class="need_review" style="vertical-align: middle; display: inline-block;"></div>
        {l s='Make sure they match your needs, then save your changes.' mod=$module_name}
    </div>
{/if}
    <div id="doctor-controls-content"{if !$needs_settings_review} style="display:none"{/if}>
        {* nofilter: This form is generated by the helper so it is secured *}
        {$settings_form nofilter}
    </div>
</div>

<div class="panel" id="doctor-controls" style="margin-top: 1rem;">
    <div class="panel-heading">
        <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/doctor-icon-checklist.png" width="25" height="25"/>
        {l s='Checklist' mod=$module_name}
        <div style="display: inline-block; margin-left:2rem;">
            <div class="counter">
                <span>{l s='Fixed' mod=$module_name}&nbsp;</span>
                <div id="counter-2" class="digits" data-counter="0"></div>
            </div>
            <div class="counter">
                <span>{l s='To fix' mod=$module_name}&nbsp;</span>
                <div id="counter-0" class="digits" data-counter="0"></div>
            </div>
            <div class="counter">
                <span>{l s='Cannot fix' mod=$module_name}&nbsp;</span>
                <div id="counter-1" class="digits" data-counter="0"></div>
            </div>
            <div class="counter">
                <span>{l s='Error' mod=$module_name}&nbsp;</span>
                <div id="counter-3" class="digits" data-counter="0"></div>
            </div>
        </div>
        <div class="panel-heading-action">
            <a class="list-toolbar-btn" href="javascript:void();" onclick="resetControls(); return false;">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Reset the control list' mod=$module_name}" data-html="true" data-placement="top">
                    <i class="process-icon-reset"></i>
                </span>
            </a>
        </div>
    </div>

    <div class="controls-intro">
        {if $control_count === 0}
            {l s='There is no control in the checklist, try to reset the module and see if it\'s better' mod=$module_name}!
        {else}
            {l s='The doctor performs %d detailed checks on your shop to guarantee speed, security, and a flawless shopping experience.' sprintf=[$control_count] mod=$module_name} 😊
        {/if}
    </div>

    <!-- Controls table -->
    <table id="datasControlsTable" class="display cell-border compact stripe" style="width:100%">
        <thead>
        <!-- Ligne principale -->
        <tr class="column-headers">
            <th rowspan="2" class="tdid">{l s='ID' mod=$module_name}</th>
            <th rowspan="2">{l s='Name' mod=$module_name}</th>
            <th rowspan="2" class="tdcenter">{l s='Last check' mod=$module_name}</th>
            <th colspan="4" class="tdcenter" style="border-bottom:none;border-left: 1px solid #dddddd;border-right: 1px solid #dddddd;">{l s='Problem count' mod=$module_name}</th>
            <th rowspan="2" class="tdcenter">{l s='Actions' mod=$module_name}</th>
        </tr>
        <!-- Sous-colonnes -->
        <tr>
            <th style="border-left: 1px solid #dddddd;" class="tdcenter">{l s='Fixed' mod=$module_name}</th>
            <th class="tdcenter">{l s='To fix' mod=$module_name}</th>
            <th class="tdcenter">{l s='Cannot fix' mod=$module_name}</th>
            <th style="border-right: 1px solid #dddddd;" class="tdcenter">{l s='Error' mod=$module_name}</th>
        </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>
<div class="panel" id="doctor-commands" style="margin-top: 1rem;">
    <div class="panel-heading">
        <i class="material-icons">terminal</i>
        {l s='Commands and CRON' mod=$module_name}
    </div>
    {if count($cron_urls_legacy) > 0}
        <div>
            <h4>{l s='Legacy CRON URLs' mod=$module_name}</h4>
            <p>{l s='To clean and optimize your database periodically (once a day is enought) your can use the following URL (one for each shop) in a CRON job:' mod=$module_name}</p>
            <ul>
                {foreach from=$cron_urls_legacy item=cron_url}
                    <li><span class="cron_url">{$cron_url|escape:'javascript':'UTF-8'}</span></li>
                {/foreach}
            </ul>
        </div>
    {/if}
    <div>
        <h4>{l s='Provided commands' mod=$module_name}</h4>
        <p>
            {l s='The doctor provides a set of commands (Symfony) to help you manage your shop directly from command line. This is helpfull to perform automatic tasks.' mod=$module_name}
        </p>
        <div class="alert alert-info" role="alert">
            {l s='If the command is not found then run "php bin/console cache:clear"' mod=$module_name}
        </div>
        <pre class="terminal">
php bin/console jprestadoctor:cron-run-controls      # {l s='Run all diagnostic available with CRON mode' mod=$module_name}
php bin/console jprestadoctor:cron-fix-problems      # {l s='Repair detected issues in CRON mode' mod=$module_name}
    </pre>

        <p>
            {l s='To view help for a specific command, run:' mod=$module_name}
        </p>
        <pre class="terminal">
php bin/console help jprestadoctor:cron-run-controls
    </pre>
    </div>
</div>
<!-- Modals -->
<!-- Modal backup -->
<div class="modal fade" id="backupWarningModal" tabindex="-1" role="dialog" aria-labelledby="backupWarningLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-warning">
                <h3 class="modal-title" id="backupWarningLabel"><i class="icon-exclamation-circle"></i>&nbsp;{l s='Backup strongly recommended' mod=$module_name}</h3>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/meca-warning.png" width="155" height="221" alt="{l s='Backup strongly recommended' mod=$module_name}"/>
                    </div>
                    <div class="col-md-8">
                        <p>{l s='The repair operations provided by this module have been carefully tested. However, since every shop has its own specific setup (hosting, third-party modules, customizations), <b>we strongly recommend creating a full backup</b> (database + files) before proceeding.' mod=$module_name js=true}</p>
                        <p><i class="icon-warning"></i>&nbsp;{l s='<b>We cannot be held responsible for any issues</b> that may occur: having a backup is your best safety guarantee.' mod=$module_name js=true}</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="backupCancelBtn" class="btn btn-secondary">{l s='Cancel' d='Shop.Theme.Actions'}</button>
                <button type="button" id="backupConfirmBtn" class="btn btn-primary">{l s='I understand! Start repairing!' mod=$module_name}</button>
                <button type="button" id="backupCloseBtn" class="btn btn-primary">{l s='Close'}</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal PRO version -->
<div class="modal fade modal-dialog-centered" id="cannotRepairModal" tabindex="-1" role="dialog" aria-labelledby="cannotRepairLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="cannotRepairLabel"><i class="icon-lock"></i>&nbsp;{l s='Upgrade to PRO!' mod=$module_name}</h3>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        <img src="{$modulePath|escape:'html':'UTF-8'}/views/img/meca-invoice.png" width="155" height="230" alt="{l s='Upgrade to PRO!' mod=$module_name}"/>
                    </div>
                    <div class="col-md-8">
                        <p>{l s='This free version allows you to analyze the status of your PrestaShop store.' mod=$module_name}</p>
                        <p>{l s='You can fix the issues manually, or upgrade to the PRO version which includes automatic repair of the detected errors.' mod=$module_name}</p>
                        <p style="font-weight: bold">{l s='With the PRO version, you’re guaranteed to apply the right fixes, quickly and with ease.' mod=$module_name}</p>
                        <a href="{l s='https://jpresta.com/en/prestashop-modules/38-doctor-pro-diagnose-repair-clean-optimize.html' mod=$module_name}?utm_source=doctor&utm_medium=referral&utm_campaign=doctor&utm_content=doctor-link" target="_blank">
                            {l s='How much is it to be a PRO' mod=$module_name}&nbsp;<i class="icon-external-link"></i>
                        </a>

                    </div>
                </div>
                <hr/>
                <div class="suggest-speed-pack"><img src="{$modulePath|escape:'html':'UTF-8'}/views/img/logo-speedpack.png" width="57" height="57" alt="Logo module Prestashop Speed Pack" style="float: left; margin: 0 10px 10px 0;"/>
                    {l s='The PRO version is also included in our <b>Speed Pack</b> module: a <b>complete package to boost your store’s performance</b> (ultra-fast cache, AVIF/WEBP image compression, SQL profiler, and more).' js=true mod=$module_name}
                    <a href="{l s='https://jpresta.com/en/prestashop-modules/6-speed-pack-page-cache-ultimate-lazy-loading-webp.html' mod=$module_name}?utm_source=doctor&utm_medium=referral&utm_campaign=doctor&utm_content=speedpack-link" target="_blank">
                        {l s='Learn more about this complete package' mod=$module_name}&nbsp;<i class="icon-external-link"></i>
                    </a>
                </div>

            </div>
            <div class="modal-footer">
                <button style="margin-bottom: 10px" type="button" class="btn btn-secondary" data-dismiss="modal">{l s='No, thanks' mod=$module_name}</button>
                <a style="margin-bottom: 10px" href="{l s='https://jpresta.com/en/prestashop-modules/38-doctor-pro-diagnose-repair-clean-optimize.html' mod=$module_name}?utm_source=doctor&utm_medium=referral&utm_campaign=doctor&utm_content=doctor-btn" target="_blank" class="btn btn-primary">{l s='Buy Doctor PRO!' mod=$module_name}</a>
                <a style="margin-bottom: 10px" href="{l s='https://jpresta.com/en/prestashop-modules/6-speed-pack-page-cache-ultimate-lazy-loading-webp.html' mod=$module_name}?utm_source=doctor&utm_medium=referral&utm_campaign=doctor&utm_content=speedpack-btn" target="_blank" class="btn btn-primary">{l s='Buy the Full Pack!' mod=$module_name}</a>
            </div>
        </div>
    </div>
</div>


<!-- Templates -->
<template id="datasProblemsTableTpl">
    <div class="problem">
        <div style="display: none">
            <h4>{l s='Description of this control' mod=$module_name}</h4>
            <div class="control_desc"></div>
        </div>
        <div style="display: none">
            <h4>{l s='How Doctor PRO will repair it' mod=$module_name}</h4>
            <div class="control_howto"></div>
        </div>
        <div style="margin-bottom: 0.5rem;">
            <h4>{l s='Here is the list of problems found by this control' mod=$module_name}</h4>
        </div>
        <table id="datasProblemsTable" class="display cell-border compact stripe" style="width:100%;">
            <thead>
            <tr class="column-headers">
                <th class="tdid">{l s='ID problem' mod=$module_name}</th>
                <th>{l s='Description' mod=$module_name}</th>
                <th class="tdcenter">{l s='State' mod=$module_name}</th>
                <th class="tdcenter" style="text-align: center;">
                    {l s='Actions' mod=$module_name}
                    <br/>
                    <button class="js-btn-repair-all btn btn-xs btn-success"><i class="icon-wrench"></i>&nbsp;{l s='Fix all' mod=$module_name}</button>
                </th>
            </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
</template>
