<?php
/**
 * Page Cache Ultimate, Page Cache standard and Speed pack are powered by Jpresta (jpresta . com)
 *
 * @author    Jpresta
 * @copyright Jpresta
 * @license   See the license of this module in file LICENSE.txt, thank you.
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

/*
 * add 1 needed column and reset controls
 */
function upgrade_module_1_0_2($module)
{
    $ret = true;
    try {
        $ret &= JPresta\SpeedPack\JprestaUtils::dbExecuteSQL('ALTER TABLE `' . _DB_PREFIX_ . 'jpresta_doctor_controls` ADD COLUMN `control_how_to_fix` TEXT DEFAULT NULL AFTER `control_description`;');
        $ret &= JPresta\SpeedPack\JprestaUtils::dbExecuteSQL('ALTER TABLE `' . _DB_PREFIX_ . 'jpresta_doctor_problems` ADD COLUMN `total_count` INT UNSIGNED NOT NULL DEFAULT 1 AFTER `problem_messages_json`;');

        JPresta\Doctor\Service\DoctorService::resetControls($module);
    } catch (Exception $e) {
        $ret = false;
        JPresta\SpeedPack\JprestaUtils::addLog('Doctor | Error in upgrade_module_1_0_2(): ' . $e->getMessage(), 2);
    }

    return (bool) $ret;
}
