<?php
/**
 * JPresta Doctor, JPresta Doctor PRO and Speed pack are powered by Jpresta (jpresta . com)
 *
 *    @author    Jpresta
 *    @copyright Jpresta
 *    @license   See the license of this module in file LICENSE.txt, thank you.
 */

namespace JPresta\Doctor\Control;

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once __DIR__ . '/../Domain/AbstractControl.php';
require_once __DIR__ . '/../Domain/Problem.php';
require_once __DIR__ . '/../../classes/JprestaUtils.php';

use JPresta\Doctor\Domain\Problem;
use JPresta\SpeedPack\JprestaUtils;

class OptimizeTablesControl extends AbstractControl
{
    /**
     * @param \PDO $pdo
     * @param string $prefix
     * @param string $config_string
     */
    public function __construct($pdo, $prefix, $config_string)
    {
        parent::__construct($pdo, $prefix, $config_string);
    }

    /**
     * @param \ModuleCore $module
     *
     * @return string
     */
    public function generateName($module)
    {
        return $module->l('Check for tables that need optimizations', 'optimizetablescontrol');
    }

    /**
     * @param \ModuleCore $module
     *
     * @return string
     */
    public function generateDescription($module)
    {
        return $module->l('Check for tables needing optimization on the database server', 'optimizetablescontrol');
    }

    /**
     * Generate a localized description of how to fix this problem.
     *
     * @param \ModuleCore $module The PrestaShop module instance
     *
     * @return string
     */
    public function generateHowToFix($module)
    {
        return $module->l('Will execute the OPTIMIZE TABLE command on the table that need it', 'optimizetablescontrol');
    }

    /**
     * {@inheritDoc}
     */
    public function run($module, $contextInfos, $onProblem)
    {
        $tables = JprestaUtils::dbSelectRows(
            'SHOW TABLE STATUS
            WHERE Data_free / Data_length > 0.1
            AND Data_free > 1024*1024*10
            AND Name LIKE \'' . pSQL($this->prefix . '%') . '\';',
            true,
            true
        );

        foreach ($tables as $table) {
            $problem = new Problem();
            $problem->problem_class = 'OptimizeTablesProblem';
            $problem->problem_description = $module->l(
                'Table %s can be optimized',
                'optimizetablescontrol',
                [$table['Name']]
            );
            $problem->problem_config = $table['Name'];
            $problem->state = Problem::STATE_TO_FIX;
            $problem->cron = 1;

            // Save the Problem
            call_user_func($onProblem, $problem);
        }
    }
}
