<?php
/**
 * JPresta Doctor, JPresta Doctor PRO and Speed Pack are powered by Jpresta (jpresta.com)
 *
 * @author    Jpresta
 * @copyright Jpresta
 * @license   See the license of this module in file LICENSE.txt
 */

namespace JPresta\Doctor\Command;

if (!defined('_PS_VERSION_')) {
    exit;
}

use JPresta\Doctor\Domain\Control;
use JPresta\Doctor\Service\DoctorService;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CronRunControlsCommand extends Command
{
    protected function configure()
    {
        $this->setName('jprestadoctor:cron-run-controls')
            ->setDescription('Run controls that are enabled for CRON jobs');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('| Running controls for CRON jobs...');

        $moduleName = basename(dirname(__DIR__, 2));
        $moduleInstance = \Module::getInstanceByName($moduleName);
        $controlsIds = Control::getAllIdsForCron();
        foreach ($controlsIds as $controlId) {
            try {
                $startTime = microtime(true);
                $currentControl = new Control($controlId);
                if (!\Validate::isLoadedObject($currentControl)) {
                    throw new \PrestaShopException("id_control=$controlId not found");
                }
                $problemCount = DoctorService::runControlById($moduleInstance, $controlId);
                $runDurationMs = round((microtime(true) - $startTime) * 1000, 0, PHP_ROUND_HALF_DOWN);
                $output->writeln("| Control \"$currentControl->control_name\" found $problemCount problems in $runDurationMs ms");
            } catch (\Exception $e) {
                $output->writeln('| Error: ' . $e->getMessage());
            }
        }
        $output->writeln('| Done.');

        // Return OK
        return 0;
    }
}
