<?php
/**
 * JPresta Doctor, JPresta Doctor PRO and Speed pack are powered by Jpresta (jpresta . com)
 *
 *    @author    Jpresta
 *    @copyright Jpresta
 *    @license   See the license of this module in file LICENSE.txt, thank you.
 */

namespace JPresta\Doctor;

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once __DIR__ . '/JprestaSubModule.php';
require_once __DIR__ . '/../src/Domain/Control.php';
require_once __DIR__ . '/../src/Domain/Problem.php';

use JPresta\Doctor\Domain\Control;
use JPresta\Doctor\Domain\Problem;
use JPresta\SpeedPack\JprestaSubModule;

// Check existence of the class to be able to handle compatibility problems in a friendly way
if (!class_exists('JPresta\Doctor\JprestaDoctorModule')) {
    require_once 'JprestaSubModule.php';

    class JprestaDoctorModule extends JprestaSubModule
    {
        public function install()
        {
            $this->module->installTab('AdminJprestaDoctorControlsDatas');
            $this->module->installTab('AdminJprestaDoctorProblemsDatas');
            Control::createTable();
            Problem::createTable();
            Control::updateControls($this->module, _PS_MODULE_DIR_ . $this->module->name . '/data/doctor-controls.json');

            return true;
        }

        public function uninstall()
        {
            if (!defined('JprestaMigPCU2SP')) {
                Problem::dropTable();
                Control::dropTable();
            }

            return true;
        }
    }
}
